// MSock.cpp :

#include "stdafx.h"
#include "Defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// MSock

//	It jumps ..the callback function when API is processed and ended
BOOL CALLBACK FinishedJump(LPMtoMSOCK pMSock,int iMtoMCode)
{
	BOOL Ret ;
	CMSock* pCMSock ;

	pCMSock = (CMSock* )pMSock->dwUser1 ;

	Ret = pCMSock->OnFinished(iMtoMCode) ;
	return( Ret );
}

//	Callback function when event is generated
void CALLBACK EventFuncJump(LPMtoMSOCK pMSock,int iCode,DWORD dwParam1,DWORD dwParam2)
{
	CMSock* pCMSock ;

	pCMSock = (CMSock* )pMSock->dwUser1 ;

	pCMSock->OnEventFunc(iCode,dwParam1,dwParam2) ;
}


//	It communicates in the asynchronous mode
void CMSock::ASyncModeEnable()
{
	m_pfFinish = FinishedJump ;
}


//	It communicates in the synchronous mode
void CMSock::SyncModeEnable()
{
	m_pfFinish = NULL;
}


CMSock::CMSock(DWORD dwProtocolType)
{
	if( m_pMSock = ::CreateMtoMSocket(dwProtocolType) ){
		m_pMSock->dwUser1 = (DWORD )this ;
		::SetMtoMEventCallBack(m_pMSock,EventFuncJump) ;

		//	Default is a synchronous mode.
		SyncModeEnable();
	}
}

CMSock::~CMSock()
{
	::FreeMtoMSoket(m_pMSock);
}

int CMSock::OpenMtoMLAN(LPCSTR szIPAddress)
{
	return( ::OpenMtoMLAN(m_pMSock,m_pfFinish,szIPAddress) );
}


int CMSock::CloseMtoM()
{
	return( ::CloseMtoM(m_pMSock,m_pfFinish)) ;
}


int CMSock::CancelMtoM()
{
	return( ::CancelMtoM(m_pMSock)) ;
}


int CMSock::MtoMESC_W(WORD wAddress,INT iDataCount,WORD* pwData)
{
	return( ::MtoMESC_W(m_pMSock,m_pfFinish,wAddress,iDataCount,pwData)) ;
}

int CMSock::MtoMESC_R(WORD wAddress,INT iDataCount,WORD* pwoData)
{
	return( ::MtoMESC_R(m_pMSock,m_pfFinish,wAddress,iDataCount,pwoData)) ;
}

int CMSock::MtoMESC_SetContrast(DWORD dwContrast,DWORD dwLight)
{
	return( ::MtoMESC_SetContrast(m_pMSock,m_pfFinish,dwContrast,dwLight)) ;
}

int CMSock::MtoMESC_GetContrast(DWORD *dwContrast,DWORD *dwLight)
{
	return( ::MtoMESC_GetContrast(m_pMSock,m_pfFinish,dwContrast,dwLight));
}

DWORD CMSock::MtoMGetLastError(void)
{
	return( ::MtoMGetLastError(m_pMSock)) ;
}

DWORD CMSock::SetTransitionType(DWORD dwTranscitonType)
{
	return( ::SetTransitionType(m_pMSock,dwTranscitonType)) ;
}

DWORD CMSock::GetTransitionType()
{
	return( ::GetTransitionType(m_pMSock)) ;
}
